% clear all; clc;

% rng(0);

N = 256;            % Port number
f_c = 3.5e9;        % Frequency

Lambda = 3e8/f_c;   % Wavelength

L = 9;              % Path number

W = 10;             % Aperture length per wavelength

% x = Lambda/2*[0:1:N-1];

x = linspace(0,W*Lambda,N)';

% Kernal_J0 = zeros(N,N);
% Kernal_exp = zeros(N,N);
% for aa = 1:N
%     for bb = 1:N
%         Kernal_J0(aa,bb) = besselj(0,2*pi*norm(x(bb)-x(aa))/Lambda);
%         Kernal_exp(aa,bb) = exp(-2*pi/Lambda*norm(x(bb)-x(aa))^2/1);
%     end
% end

Rep = 100;
Kernal_SV_mean = zeros(N,N);
Kernal_CDL_mean = zeros(N,N);
for rp = 1:Rep
    h = SV_channel(x,Lambda,L);
    Kernal_SV_mean = Kernal_SV_mean + h*h';
    h = CDL_channel(x, f_c);
    Kernal_CDL_mean = Kernal_CDL_mean + h*h';
end
Kernal_SV_mean = Kernal_SV_mean/Rep;
Kernal_CDL_mean = Kernal_CDL_mean/Rep;

save('Kernal.mat','N','x','L' ...
    ,'Kernal_SV_mean','Kernal_CDL_mean');

